package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.annotations.Internal;

@Internal
public enum TabPanelOrder {
    OLDEST_FIRST("asc"), NEWEST_FIRST("desc");

    private final String text;

    TabPanelOrder(String text) {
        this.text = text;
    }

    public String asText() {
        return text;
    }

    public static TabPanelOrder fromString(String string) {
        return "asc".equals(string) ? OLDEST_FIRST : NEWEST_FIRST;
    }
}
