package com.atlassian.jira.plugin.issuetabpanel;

import com.google.common.collect.ImmutableList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultPage<T> implements Page<T> {
    private final List<T> pageContents;
    private final boolean isFirstPage;
    private final boolean isLastPage;

    private DefaultPage(List<T> pageContents, boolean isFirstPage, boolean isLastPage) {
        this.pageContents = ImmutableList.copyOf(Objects.requireNonNull(pageContents));
        this.isFirstPage = isFirstPage;
        this.isLastPage = isLastPage;
    }

    public static <T> DefaultPage<T> first(Collection<T> coll) {
        return new DefaultPage<>(new ArrayList<>(coll), true, false);
    }

    public static <T> DefaultPage<T> last(Collection<T> coll) {
        return new DefaultPage<>(new ArrayList<>(coll), false, true);
    }

    public static <T> DefaultPage<T> only(Collection<T> coll) {
        return new DefaultPage<>(new ArrayList<>(coll), true, true);
    }

    public static <T> DefaultPage<T> nth(Collection<T> coll) {
        return new DefaultPage<>(new ArrayList<>(coll), false, false);
    }

    public static Page<IssueAction> empty() {
        return new DefaultPage<>(Collections.emptyList(), true, true);
    }

    @Override
    public List<T> getPageContents() {
        return ImmutableList.copyOf(pageContents);
    }

    @Override
    public boolean isFirstPage() {
        return isFirstPage;
    }

    @Override
    public boolean isLastPage() {
        return isLastPage;
    }

    @Override
    public String toString() {
        return pageContents.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DefaultPage<?> that = (DefaultPage<?>) o;
        return isFirstPage == that.isFirstPage && isLastPage == that.isLastPage && pageContents.equals(that.pageContents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageContents, isFirstPage, isLastPage);
    }
}
