package com.atlassian.jira.monitoring;

import com.atlassian.annotations.PublicApi;

/**
 * This service takes care of turning on and off In Product Diagnostics
 * metrics in e.g. the unlikely case they themselves cause performance issues.
 * <p>
 * The metrics are output via JMX and to a log file.
 *
 * @since 9.4.3
 */
@PublicApi
public interface IpdMonitoringControlService {

    /**
     * @return the current Ipd monitoring state
     */
    boolean isIpdMonitoringEnabled();

    /**
     * Set Ipd monitoring should be enabled. In the case of disabled JMX, it enables JMX as well.
     *
     * @param isEnabled the desired application monitoring state
     */
    void setIpdMonitoringEnabled(boolean isEnabled);
}
