package com.atlassian.jira.issue.link;

public class RemoteIssue {
    private static final boolean IS_REMOTE = true;

    private final String key;
    private final boolean resolution;
    private final String redirectUrl;
    private final String summary;

    public RemoteIssue(final String key,
                       final boolean resolution,
                       final String redirectUrl,
                       final String summary) {
        this.key = key;
        this.resolution = resolution;
        this.redirectUrl = redirectUrl;
        this.summary = summary;
    }

    public String getKey() {
        return key;
    }

    public boolean getResolution() {
        return resolution;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public String getSummary() {
        return summary;
    }

    public boolean isRemote() {
        return IS_REMOTE;
    }
}
