package com.atlassian.jira.issue.fields.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Finds an issue based on its 'id' or 'key'.
 * For the key, it will follow moved issues, and try to match the key in a case-insensitive way
 *
 * @since v8.21
 */
public interface IssueFinderV2 {
    /**
     * Search result for any other case than found issue
     */
    enum SearchResult {
        ISSUE_DOES_NOT_EXIST,
        USER_HAS_NO_ACCESS,
        INCORRECT_PARAM
    }

    /**
     * Finds an issue based on the passed-in id or key.
     *
     * @param idOrKey a string that may be an id or a key
     * @return an {@code Issue} or {@link SearchResult}
     */
    @Nonnull
    Either<SearchResult, Issue> findIssue(@Nullable String idOrKey);
}
