package com.atlassian.jira.issue.fields;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;

import javax.annotation.Nonnull;

/**
 * {@link ConfigurableField} that adds support for default values.
 *
 * @since 8.16
 */
@ExperimentalApi
@PublicApi
public interface DefaultValueField<V> extends ConfigurableField<V> {

    @Nonnull
    default DefaultValueOperations<V> getDefaultValueOperations() {
        return DefaultValueOperations.NOT_SUPPORTED;
    }
}
