package com.atlassian.jira.issue.customfields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValue;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @since 8.12
 */
public class DefaultNonNullCustomFieldProvider implements NonNullCustomFieldProvider {
    private final CustomFieldValuePersister customFieldValuePersister;

    public DefaultNonNullCustomFieldProvider(final CustomFieldValuePersister customFieldValuePersister) {
        this.customFieldValuePersister = customFieldValuePersister;
    }

    @Override
    @Deprecated
    public Map<String, CustomFieldPrefetchedData> getCustomFieldInfo(final Issue issue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Long, Map<String, CustomFieldPrefetchedData>> getCustomFieldInfo(final List<Issue> issues) {
        final Set<Long> issueIds = issues.stream()
                .map(Issue::getId)
                .collect(Collectors.toSet());

        final Function<Map.Entry<Long, List<CustomFieldValue>>, Map<String, CustomFieldPrefetchedData>> entryFunction = entry -> entry.getValue().stream()
                .map(CustomFieldValue::getFieldId)
                .collect(Collectors.toMap(Function.identity(), k -> CustomFieldPrefetchedData.NO_PREFETCH));

        return customFieldValuePersister.getValues(issueIds).entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, entryFunction));
    }

    @Override
    public Object getIdentity() {
        return customFieldValuePersister.getIdentity();
    }
}
