package com.atlassian.jira.i18n.terminology;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import java.util.Optional;

/**
 * This event is fired before terminology is changed.
 * <p>
 * That means terminology hasn't been changed and Jira can still return old values for terminology.
 * <p>
 * In Jira Data Center the event is published only for changes done on current Jira node.
 * </p>
 *
 * @since v8.16
 */
@Immutable
@ParametersAreNonnullByDefault
public final class TerminologyPreChangeEvent extends AbstractTerminologyEvent {
    public TerminologyPreChangeEvent(final Optional<TerminologyEntry> previousEntry, final TerminologyEntry currentEntry) {
        super(currentEntry.getOriginalName(),
                currentEntry.getNewName(),
                currentEntry.getNewNamePlural(),
                previousEntry.isPresent() ? previousEntry.get().getNewName() : currentEntry.getOriginalName(),
                previousEntry.isPresent() ? previousEntry.get().getNewNamePlural() : currentEntry.getOriginalNamePlural());
    }
}
