package com.atlassian.jira.event.user;

import com.atlassian.jira.user.UserDefaultSettings;

public final class UserDefaultSettingsUpdatedEvent {
    private final UserDefaultSettings previousSettings;
    private final UserDefaultSettings currentSettings;

    public UserDefaultSettingsUpdatedEvent(UserDefaultSettings previousSettings, UserDefaultSettings currentSettings) {
        this.previousSettings = previousSettings;
        this.currentSettings = currentSettings;
    }

    public UserDefaultSettings getPreviousSettings() {
        return previousSettings;
    }

    public UserDefaultSettings getCurrentSettings() {
        return currentSettings;
    }
}
