package com.atlassian.jira.event.user;

/**
 * Event sent just before user {@link #username} is authenticated. This event should be published before every log in attempt.
 * It ensures that all the operations required before a login attempt are performed.
 * It should be published before each User Directory is searched for the user with the given username. The event should be published once for every authentication attempt.
 * It should be published only for authentication requests.
 */
public class BeforeUserAuthenticate {

    private String username;

    public BeforeUserAuthenticate(final String username) {
        this.username = username;
    }

    public String getUsername() {
        return username;
    }

    @Override
    public String toString() {
        return "BeforeUserAuthenticate{" +
                "username='" + username + '\'' +
                '}';
    }
}
