package com.atlassian.jira.event.mail.template;

import com.atlassian.jira.user.ApplicationUser;

import javax.annotation.Nullable;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

public abstract class BaseEmailTemplatesEvent {

    private final ApplicationUser user;
    private final boolean operationSuccessful;


    protected BaseEmailTemplatesEvent(final ApplicationUser user, final boolean operationSuccessful) {
        this.user = requireNonNull(user);
        this.operationSuccessful = operationSuccessful;
    }

    public ApplicationUser getUser() {
        return user;
    }


    public boolean isOperationSuccessful() {
        return operationSuccessful;
    }

    @Override
    public boolean equals(@Nullable final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final BaseEmailTemplatesEvent that = (BaseEmailTemplatesEvent) o;
        return operationSuccessful == that.isOperationSuccessful() && user.equals(that.getUser());
    }

    @Override
    public int hashCode() {
        return Objects.hash(user, operationSuccessful);
    }
}
