package com.atlassian.jira.event.mail.analytics;

import com.atlassian.analytics.api.annotations.EventName;

/**
 * Published when image attachment with JWT token is requested.
 * Token carries information about token creation time and that can be used to calculate delay between sending an email and opening it
 */
@EventName("notification.email.attachment.loaded")
public class NotificationEmailAttachmentLoadedAnalyticsEvent {
    private final String uniqueUserEmailImageAttachmentKey;
    private long delayBetweenEmailSendAndOpenSeconds;

    public NotificationEmailAttachmentLoadedAnalyticsEvent(String uniqueUserEmailAttachmentKey, long delayBetweenEmailSendAndOpenSeconds) {
        this.uniqueUserEmailImageAttachmentKey = uniqueUserEmailAttachmentKey;
        this.delayBetweenEmailSendAndOpenSeconds = delayBetweenEmailSendAndOpenSeconds;
    }

    public String getUniqueUserEmailImageAttachmentKey() {
        return uniqueUserEmailImageAttachmentKey;
    }

    public long getDelayBetweenEmailSendAndOpenSeconds() {
        return delayBetweenEmailSendAndOpenSeconds;
    }
}
