package com.atlassian.jira.event.issue.link;

import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.user.ApplicationUser;

public class RemoteIssueLinkDecoratedEvent extends AbstractRemoteIssueLinkEvent{
    private final RemoteIssueLink remoteIssueLink;
    private final ApplicationUser user;

    public RemoteIssueLinkDecoratedEvent(final RemoteIssueLink remoteIssueLink, final ApplicationUser user) {
        super(remoteIssueLink);
        this.remoteIssueLink = remoteIssueLink;
        this.user = user;
    }

    public RemoteIssueLink getRemoteIssueLink() {
        return remoteIssueLink;
    }

    public ApplicationUser getUser() {
        return user;
    }
}
