package com.atlassian.jira.event.issue.field;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.Internal;

/**
 * since 8.16
 */
@EventName("administration.customfields.rest.bulk.delete")
public class CustomFieldsBulkDeleteEvent {
    private final Long startTime;
    private final Long endTime;
    private final int selectedCustomFields;
    private final int deletedCustomFields;
    private final int status;

    @Internal
    public CustomFieldsBulkDeleteEvent(final Long startTime,
                                       final Long endTime,
                                       final int selectedCustomFields,
                                       final int deletedCustomFields,
                                       final int status) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.selectedCustomFields = selectedCustomFields;
        this.deletedCustomFields = deletedCustomFields;
        this.status = status;
    }

    public Long getStartTime() {
        return startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public int getSelectedCustomFields() {
        return selectedCustomFields;
    }

    public int getDeletedCustomFields() {
        return deletedCustomFields;
    }

    public int getStatus() {
        return status;
    }
}
