package com.atlassian.jira.event.issue.field;

import com.atlassian.jira.issue.fields.CustomField;

import javax.annotation.Nonnull;

/**
 * Event indicating a custom field has been deleted.
 *
 * @since v5.1
 */
public class CustomFieldDeletedEvent extends AbstractCustomFieldEvent {
    private final Long lastValueUpdate;
    private final Long issuesWithValue;

    public CustomFieldDeletedEvent(@Nonnull CustomField customField) {
        super(customField);

        this.lastValueUpdate = customField.getLastValueUpdate() != null ? customField.getLastValueUpdate().getTime() : null;
        this.issuesWithValue = customField.getIssuesWithValue();
    }

    public Long getLastValueUpdate() {
        return lastValueUpdate;
    }

    public Long getIssuesWithValue() {
        return issuesWithValue;
    }
}
