package com.atlassian.jira.event.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import java.util.Objects;
import java.util.Set;

import static java.util.Collections.emptySet;
import static java.util.Objects.requireNonNull;

/**
 * @see MentionIssueEvent except that only fires for mentions on comments.
 * @since v5.0.2
 */
@PublicApi
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class MentionIssueCommentEvent extends MentionIssueEvent {
    private final Comment comment;

    @Deprecated
    public MentionIssueCommentEvent(Issue issue,
                                    ApplicationUser fromUser,
                                    Set<ApplicationUser> toUsers,
                                    String mentionText,
                                    String fieldId,
                                    @Nullable Set<NotificationRecipient> currentRecipients,
                                    Comment comment) {
        this(issue, fromUser, toUsers, emptySet(), mentionText, fieldId, currentRecipients, comment);
    }

    public MentionIssueCommentEvent(Issue issue,
                                    ApplicationUser fromUser,
                                    Set<ApplicationUser> toUsers,
                                    Set<NotificationRecipient> recipients,
                                    String mentionText,
                                    String fieldId,
                                    @Nullable Set<NotificationRecipient> currentRecipients,
                                    Comment comment) {
        super(issue, fromUser, toUsers, recipients, mentionText, fieldId, currentRecipients);
        this.comment = requireNonNull(comment);
    }

    public Comment getComment() {
        return comment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        MentionIssueCommentEvent that = (MentionIssueCommentEvent) o;
        return Objects.equals(comment, that.comment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), comment);
    }

    @Override
    public String toString() {
        return "MentionIssueCommentEvent{" +
                "comment=" + comment +
                '}';
    }
}
