package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.status.Status;

import java.util.Objects;

/**
 * Published when issue status is successfully deleted.
 */
@Internal
public class StatusDeletedEvent extends AbstractEvent {
    private final Status status;

    public StatusDeletedEvent(Status status) {
        super();
        this.status = status;
    }

    public Status getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        StatusDeletedEvent that = (StatusDeletedEvent) o;
        return Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), status);
    }

    @Override
    public String toString() {
        return "StatusDeletedEvent{" +
                "status=" + status +
                '}';
    }
}
