package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.priority.Priority;

import java.util.Objects;

/**
 * Published when issue priority is successfully edited.
 */
@Internal
public class PriorityEditedEvent extends AbstractEvent {
    private final Priority originalPriority;
    private final Priority updatedPriority;

    public PriorityEditedEvent(Priority originalPriority, Priority updatedPriority) {
        super();
        this.originalPriority = originalPriority;
        this.updatedPriority = updatedPriority;
    }

    public Priority getOriginalPriority() {
        return originalPriority;
    }

    public Priority getUpdatedPriority() {
        return updatedPriority;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PriorityEditedEvent that = (PriorityEditedEvent) o;
        return Objects.equals(originalPriority, that.originalPriority) &&
                Objects.equals(updatedPriority, that.updatedPriority);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), originalPriority, updatedPriority);
    }

    @Override
    public String toString() {
        return "PriorityEditedEvent{" +
                "originalPriority=" + originalPriority +
                ", updatedPriority=" + updatedPriority +
                '}';
    }
}
