package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.priority.Priority;

import java.util.Objects;

/**
 * Published when issue priority is successfully created.
 */
@Internal
public class PriorityCreatedEvent extends AbstractEvent {
    private final Priority priority;

    public PriorityCreatedEvent(Priority priority) {
        super();
        this.priority = priority;
    }

    public Priority getPriority() {
        return priority;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PriorityCreatedEvent that = (PriorityCreatedEvent) o;
        return Objects.equals(priority, that.priority);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), priority);
    }

    @Override
    public String toString() {
        return "PriorityCreatedEvent{" +
                "priority=" + priority +
                '}';
    }
}
