package com.atlassian.jira.event.config;

import com.atlassian.jira.event.AbstractEvent;

/**
 * Event fired when sub-tasks functionality is enabled or disabled
 *
 * @since v8.6
 */
public final class SubTasksStateChangedEvent extends AbstractEvent {
    private final boolean enabled;

    public SubTasksStateChangedEvent(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return enabled;
    }
}
