package com.atlassian.jira.event.comment;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.comments.Comment;

/**
 * Event published when a new comment is created.
 */
@PublicApi
public final class CommentCreatedEvent extends AbstractCommentEvent implements CommentEvent {

    private final boolean sendMail;
    private final boolean partOfIssueChange;

    public CommentCreatedEvent(Comment comment) {
        this(comment, true, false);
    }

    public CommentCreatedEvent(Comment comment, boolean sendMail, boolean partOfIssueChange) {
        super(comment);
        this.sendMail = sendMail;
        this.partOfIssueChange = partOfIssueChange;
    }

    /**
     * @return if a mail should be send for this comment creation.
     * @since v7.4.0
     */
    public boolean isSendMail() {
        return sendMail;
    }

    /**
     * @return if the comment creation was part of issue editing.
     * Needed to distinguish for bulk edits if the event can be ignored,
     * as there will be an IssueChangedEvent and IssueEvent as well.
     * @since v7.4.0
     */
    public boolean isPartOfIssueEdit() {
        return partOfIssueChange;
    }
}
