package com.atlassian.jira.bc.user.search;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.google.protobuf.ExperimentalApi;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

import static com.google.common.base.Preconditions.checkArgument;

@ExperimentalApi
public class UserSearchIssueContext {

    @Nonnull
    private final Project project;

    /**
     * In the context of creating a new issue in {@code project}, {@code issue} is null.
     */
    @Nullable
    private final Issue issue;

    private UserSearchIssueContext(final Project project, final Issue issue) {
        checkArgument(project != null);
        this.project = project;
        this.issue = issue;
    }

    public static UserSearchIssueContext create(final Issue issue) {
        checkArgument(issue.getProjectObject() != null, "Project for issue: %s is null", issue);
        return new UserSearchIssueContext(issue.getProjectObject(), issue);
    }

    public static UserSearchIssueContext createForNewIssue(Project project) {
        checkArgument(project != null, "Project cannot be null");
        return new UserSearchIssueContext(project, null);
    }

    public Optional<Long> getIssueId() {
        return Optional.ofNullable(issue).map(Issue::getId);
    }

    public Long getProjectId() {
        return project.getId();
    }

    public Optional<Issue> getIssue() {
        return Optional.ofNullable(issue);
    }

    public Project getProject() {
        return project;
    }

}
