package com.atlassian.jira.bc.safeguards;

import com.atlassian.annotations.ExperimentalApi;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Manages the retrieval of the limits.
 *
 * @since 9.0.0
 */
@ExperimentalApi
public interface SafeguardsManager {

    /**
     * Retrieves the limit or {@code null} if not found.
     *
     * @param limitKey key of the limit to be retrieved
     * @return the limit or {@code null}.
     */
    @Nullable
    String getLimit(@Nonnull String limitKey);
}
