package com.atlassian.jira.bc.safeguards;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.config.properties.APKeys;

/**
 * Holds all the Jira related Safeguards keys.
 *
 * @since 9.0.0
 */
@ExperimentalApi
public final class SafeguardsKeys {

    /**
     * Represents the key for the limit of comments of an issue.
     */
    public static final String ISSUE_COMMENTS = APKeys.JIRA_SAFEGUARDS_ISSUE_COMMENTS;

    /**
     * Represents the key for the restricted groups in Safeguards feature.
     */
    public static final String RESTRICTED_GROUPS = APKeys.JIRA_SAFEGUARDS_RESTRICTED_GROUPS;

    private SafeguardsKeys() {
    }
}
