/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.UserFilter;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSearchParams {
    private static final Logger log = LoggerFactory.getLogger(UserSearchParams.class);
    public static final int MAXIMUM_RESULTS = 100;
    @Deprecated
    public static final UserSearchParams ACTIVE_USERS_IGNORE_EMPTY_QUERY = new UserSearchParams(false, true, false, false, null, null);
    @Deprecated
    public static final UserSearchParams ACTIVE_USERS_ALLOW_EMPTY_QUERY = new UserSearchParams(true, true, false, false, null, null);
    public static final UserSearchParams LIMITED_ACTIVE_USERS_IGNORE_EMPTY_QUERY = new UserSearchParams(false, true, false, false, null, null, 100, true, false);
    public static final UserSearchParams LIMITED_ACTIVE_USERS_ALLOW_EMPTY_QUERY = new UserSearchParams(true, true, false, false, null, null, 100, true, false);
    private final boolean allowEmptyQuery;
    private final boolean includeActive;
    private final boolean includeInactive;
    private final boolean canMatchEmail;
    private final UserFilter userFilter;
    private final Set<Long> projectIds;
    @Nonnull
    @Deprecated
    private final Predicate<User> postProcessingFilter;
    private final Integer maxResults;
    private final boolean sorted;
    private final boolean ignorePermissionCheck;
    private final boolean forceStrongConsistency;

    @Deprecated
    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive) {
        this(allowEmptyQuery, includeActive, includeInactive, false, null, null);
    }

    @Deprecated
    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, (Predicate<User>)Predicates.alwaysTrue());
    }

    @Deprecated
    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, Predicate<User> postProcessingFilter) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, postProcessingFilter, null, true, false);
    }

    @Deprecated
    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, Predicate<User> postProcessingFilter, Integer maxResults) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, postProcessingFilter, maxResults, true, false);
    }

    @Deprecated
    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, Predicate<User> postProcessingFilter, Integer maxResults, boolean sorted) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, postProcessingFilter, maxResults, sorted, false);
    }

    @Deprecated
    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, Predicate<User> postProcessingFilter, Integer maxResults, boolean sorted, boolean ignorePermissionCheck) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, postProcessingFilter, maxResults, sorted, ignorePermissionCheck, false);
    }

    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, int limit, boolean sorted, boolean ignorePermissionCheck) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, limit, sorted, ignorePermissionCheck, false);
    }

    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, int limit, boolean sorted, boolean ignorePermissionCheck, boolean forceStrongConsistency) {
        this.allowEmptyQuery = allowEmptyQuery;
        this.includeActive = includeActive;
        this.includeInactive = includeInactive;
        this.canMatchEmail = canMatchEmail;
        this.userFilter = userFilter;
        this.projectIds = projectIds;
        this.postProcessingFilter = Predicates.alwaysTrue();
        if (limit > 100) {
            log.trace("limit {} exceeded the maximum. Setting limit to max: {}", (Object)limit, (Object)100);
            this.maxResults = 100;
        } else {
            this.maxResults = limit;
        }
        this.sorted = sorted;
        this.ignorePermissionCheck = ignorePermissionCheck;
        this.forceStrongConsistency = forceStrongConsistency;
    }

    @Deprecated
    private UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, Predicate<User> postProcessingFilter, Integer maxResults, boolean sorted, boolean ignorePermissionCheck, boolean forceStrongConsistency) {
        this.allowEmptyQuery = allowEmptyQuery;
        this.includeActive = includeActive;
        this.includeInactive = includeInactive;
        this.canMatchEmail = canMatchEmail;
        this.userFilter = userFilter;
        this.projectIds = projectIds;
        this.postProcessingFilter = postProcessingFilter == null ? Predicates.alwaysTrue() : postProcessingFilter;
        this.maxResults = maxResults;
        this.sorted = sorted;
        this.ignorePermissionCheck = ignorePermissionCheck;
        this.forceStrongConsistency = forceStrongConsistency;
    }

    public boolean allowEmptyQuery() {
        return this.allowEmptyQuery;
    }

    public boolean includeActive() {
        return this.includeActive;
    }

    public boolean includeInactive() {
        return this.includeInactive;
    }

    public boolean canMatchEmail() {
        return this.canMatchEmail;
    }

    public UserFilter getUserFilter() {
        return this.userFilter;
    }

    public Set<Long> getProjectIds() {
        return this.projectIds;
    }

    public boolean ignorePermissionCheck() {
        return this.ignorePermissionCheck;
    }

    @Nonnull
    @Deprecated
    public Predicate<User> getPostProcessingFilter() {
        return this.postProcessingFilter;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isForcingStrongConsistency() {
        return this.forceStrongConsistency;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(int limit) {
        return new Builder(limit);
    }

    public static Builder builder(UserSearchParams prototype) {
        return new Builder(prototype);
    }

    public static class Builder {
        private boolean allowEmptyQuery = false;
        private boolean includeActive = true;
        private boolean includeInactive = false;
        private boolean canMatchEmail = false;
        private UserFilter userFilter = null;
        private Set<Long> projectIds = null;
        @Deprecated
        private Predicate<User> postProcessingFilter;
        private Integer maxResults;
        private boolean sorted = true;
        private boolean ignorePermissionCheck = false;
        private boolean forceStrongConsistency = false;

        @Deprecated
        public Builder() {
        }

        public Builder(int limit) {
            this.maxResults = limit;
        }

        private Builder(UserSearchParams prototype) {
            this.allowEmptyQuery = prototype.allowEmptyQuery;
            this.includeActive = prototype.includeActive;
            this.includeInactive = prototype.includeInactive;
            this.canMatchEmail = prototype.canMatchEmail;
            this.userFilter = prototype.userFilter;
            this.projectIds = prototype.projectIds;
            this.postProcessingFilter = prototype.postProcessingFilter;
            this.maxResults = prototype.maxResults;
            this.sorted = prototype.sorted;
            this.ignorePermissionCheck = prototype.ignorePermissionCheck;
            this.forceStrongConsistency = prototype.forceStrongConsistency;
        }

        public UserSearchParams build() {
            return new UserSearchParams(this.allowEmptyQuery, this.includeActive, this.includeInactive, this.canMatchEmail, this.userFilter, this.projectIds, this.postProcessingFilter, this.maxResults, this.sorted, this.ignorePermissionCheck, this.forceStrongConsistency);
        }

        public Builder allowEmptyQuery(boolean allowEmptyQuery) {
            this.allowEmptyQuery = allowEmptyQuery;
            return this;
        }

        public Builder includeActive(boolean includeActive) {
            this.includeActive = includeActive;
            return this;
        }

        public Builder includeInactive(boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public Builder canMatchEmail(boolean canMatchEmail) {
            this.canMatchEmail = canMatchEmail;
            return this;
        }

        public Builder filter(UserFilter userFilter) {
            this.userFilter = userFilter;
            return this;
        }

        public Builder filterByProjectIds(Collection<Long> projectIds) {
            this.projectIds = projectIds == null ? null : ImmutableSet.copyOf(projectIds);
            return this;
        }

        @Deprecated
        public Builder filter(Predicate<User> postProcessingFilter) {
            this.postProcessingFilter = postProcessingFilter;
            return this;
        }

        @Deprecated
        public Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder limitResults(int limit) {
            this.maxResults = limit;
            return this;
        }

        public Builder sorted(boolean sorted) {
            this.sorted = sorted;
            return this;
        }

        public Builder ignorePermissionCheck(boolean ignorePermissionCheck) {
            this.ignorePermissionCheck = ignorePermissionCheck;
            return this;
        }

        public Builder forceStrongConsistency(boolean forceStrongConsistency) {
            this.forceStrongConsistency = forceStrongConsistency;
            return this;
        }
    }
}

