/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Internal
public class FieldConfigSchemeParameters {
    private final FieldConfigScheme fieldConfigScheme;
    private final Long[] projectIds;
    private final List<IssueType> issueTypes;
    private final Object defaultValue;

    private FieldConfigSchemeParameters(FieldConfigScheme fieldConfigScheme, Long[] projectIds, List<IssueType> issueTypes, Object defaultValue) {
        this.fieldConfigScheme = fieldConfigScheme;
        this.projectIds = projectIds;
        this.issueTypes = issueTypes;
        this.defaultValue = defaultValue;
    }

    public FieldConfigScheme getFieldConfigScheme() {
        return this.fieldConfigScheme;
    }

    public Long[] getProjectIds() {
        return this.projectIds;
    }

    public boolean isGlobal() {
        return this.projectIds.length == 0;
    }

    public List<IssueType> getIssueTypes() {
        return this.issueTypes;
    }

    public boolean isAnyIssueType() {
        return this.issueTypes.size() == 1 && this.issueTypes.get(0) == null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public static Builder withScheme(FieldConfigScheme fieldConfigScheme) {
        return new Builder(fieldConfigScheme);
    }

    public ConfigurableField<?> getField() {
        return this.fieldConfigScheme.getField();
    }

    public static class Builder {
        private FieldConfigScheme fieldConfigScheme;
        private Long[] projectIds;
        private List<IssueType> issueTypes;
        private Object defaultValue;

        private Builder(FieldConfigScheme fieldConfigScheme) {
            this.fieldConfigScheme = fieldConfigScheme;
        }

        public Builder projectIds(Collection<Long> ids) {
            this.projectIds = ids.toArray(new Long[0]);
            return this;
        }

        public Builder projects(Collection<Project> projects) {
            this.projectIds = (Long[])projects.stream().map(Project::getId).toArray(Long[]::new);
            return this;
        }

        public Builder allProjects() {
            this.projectIds = new Long[0];
            return this;
        }

        public Builder anyIssueType() {
            this.issueTypes = new ArrayList<IssueType>();
            this.issueTypes.add(null);
            return this;
        }

        public Builder issueTypes(Collection<IssueType> types) {
            if (types.isEmpty()) {
                throw new IllegalArgumentException("Empty list of issue types isn't allowed. Use anyIssueType() instead.");
            }
            this.issueTypes = ImmutableList.copyOf(types);
            return this;
        }

        public Builder defaultValue(Object value) {
            this.defaultValue = value;
            return this;
        }

        public FieldConfigSchemeParameters build() {
            Preconditions.checkNotNull((Object)this.projectIds, (Object)"Projects are not set");
            Preconditions.checkNotNull(this.issueTypes, (Object)"Issue types are not set");
            return new FieldConfigSchemeParameters(this.fieldConfigScheme, this.projectIds, this.issueTypes, this.defaultValue);
        }
    }
}

