package com.atlassian.jira.util;

import javax.annotation.Nullable;

/**
 * Responsible for serializing/deserializing java objects to/from xml.
 */
public interface XmlConverter {

    /**
     * Serializes object to xml.
     * @param obj instance of any class. Can be null.
     * @return String with serialized object. If obj is null, returns null.
     */
    String toXml(@Nullable final Object obj);

    /**
     * Deserializes object from xml.
     * @param xml java object serialized to xml. Can be null.
     * @return Deserialized object. If xml is null or empty, returns null.
     */
    Object fromXml(@Nullable final String xml);
}
