package com.atlassian.jira.sharing.rights;

import com.atlassian.annotations.ExperimentalApi;

import java.io.Serializable;

/**
 * @since v7.12
 */
@ExperimentalApi
public interface ShareRight extends Serializable {
    /**
     * Checks if this share right gives rights to view and edit
     *
     * @return true if this share right gives rights to view and edit, false otherwise
     */
    @ExperimentalApi
    boolean hasEditRightsGranted();

    /**
     * Checks if this share right gives rights to view
     *
     * @return true if this share right gives rights to view, false otherwise
     */
    @ExperimentalApi
    boolean hasViewRightsGranted();
}
