package com.atlassian.jira.security.serialization;


import javax.validation.constraints.NotNull;
import java.util.Set;

/**
 * A provider of classes that should be added to the xml serialization and deserialization allowlist.
 */
public interface XmlPluginAllowlistProvider {
    /**
     * Return names of classes that are allowed to be serialized and deserialized to xml.
     *
     * @see Class#getName()
     */
    @NotNull
    Set<String> getAllowlistedClasses();
}
