package com.atlassian.jira.security.request;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The annotation used to specify list of supported request methods by "webaction command"
 *
 * @since 9.0.0
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(value = {ElementType.METHOD, ElementType.TYPE})
public @interface SupportedMethods {
	RequestMethod[] value();
}
