package com.atlassian.jira.security.request;

import com.atlassian.annotations.PublicApi;
import webwork.action.Action;

import javax.annotation.Nonnull;

/**
 * Checks that a web-request (WebWork action) has been invoked with the correct
 * request method.
 *
 * @since 9.0.0
 */
@PublicApi
public interface RequestMethodChecker {

	/**
	 * Checks that the action about to be executed has been invoked within the correct request method.
	 * This method will perform the check for all "commands" even if they are not annotated with
	 * {@link com.atlassian.jira.security.request.SupportedMethods}.
	 * For "commands" with missing {@link com.atlassian.jira.security.request.SupportedMethods} checker assume
	 * that "command" can be invoked only with POST method.
	 *
	 * @param action the {@link webwork.action.ActionSupport} in play. Cannot be null.
	 * @param requestMethod request method action was called within
	 * @return result of request method check
	 */
	RequestMethodCheckResult checkActionInvocation(@Nonnull Action action, @Nonnull String requestMethod);
}
