package com.atlassian.jira.security.request;

import com.atlassian.annotations.PublicApi;

import java.util.Locale;

/**
 * List of HTTP request methods
 * @since 9.0.0
 */
@PublicApi
public enum RequestMethod {
	GET,
	HEAD,
	OPTIONS,
	CONNECT,
	DELETE,
	POST,
	PUT,
	PATCH,
	TRACE;

	public boolean matches(String method){
		return this.name().toUpperCase(Locale.ROOT).equals(method.toUpperCase(Locale.ROOT));
	}
}
