package com.atlassian.jira.monitoring.jmx;

import com.atlassian.annotations.PublicApi;

import java.util.List;

/**
 * Exposes metrics to JMX; usually about the state of the Jira instance, the environment being run within, and the
 * larger system (e.g DB connection, Tomcat thread pool).
 *
 * @since 7.6
 */
@PublicApi
public interface JmxMetricsExposer {

    /**
     * Collects currently available metrics and exposes them through JMX.
     * Generates an analytics event.
     */
    void startExposing();

    /**
     * Unregisters currently registered metrics from JMX.
     * Generates an analytics event.
     */
    void stopExposing();

    /**
     * Publishes a cluster-wide message to refresh JMX state.
     * This method should be called if it is desired to start or stop exposing metrics in other nodes.
     */
    void publishRefreshMessage();

    /**
     * @return List of currently available metrics.
     */
    List<String> getExposedMetricNames();

    /**
     * @return boolean True if currently available metrics are registered to JMX, false otherwise.
     */
    boolean isJmxEnabled();

    /**
     * Initializes the service.
     */
    void init();
}
