package com.atlassian.jira.monitoring;

import com.atlassian.annotations.PublicApi;

/**
 * App (add-ons / plugins) metrics are newly added metrics which were introduced to Jira and various bundled apps to
 * help customers and us troubleshoot issues with third party apps. This service takes care of turning off this set of
 * metrics in e.g. the unlikely case they themselves cause performance issues.
 * <p>
 * The metrics are output via JMX and to a log file.
 *
 * @since 9.1
 */
@PublicApi
public interface AppMonitoringMetricsService {

    /**
     * @return the current App monitoring state
     */
    boolean isAppMonitoringEnabled();

    /**
     * Set App monitoring should be enabled
     *
     * @param isEnabled the desired application monitoring state
     */
    void setAppMonitoringEnabled(boolean isEnabled);
}
