package com.atlassian.jira.mail;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;

import java.io.File;
import java.io.InputStream;

/**
 * Interface to work with email templates files
 * Intended to work with both: single and batched emails
 * Used in REST API plugin to create a possibility to change email templates
 *
 * @since v8.14
 */
@ExperimentalApi
public interface MailTemplatesService {

    /**
     * Saves a stream to disk and unzips it's content to the temporary templates folder. Then performs validation
     * to check existence of root templates.
     *
     * @return Valid ServiceOutcome when templates were unzipped and all root files exists
     * Invalid ServiceOutcome with errors otherwise
     */
    ServiceOutcome<Void> uploadEmailTemplates(final InputStream templatesStream);

    /**
     * If the temporary folder with email templates is present, it will replace the production templates with temporary
     * ones
     *
     * @return Valid ServiceOutcome when templates replaced
     * Invalid ServiceOutcome with errors otherwise
     */
    ServiceOutcome<Void> applyEmailTemplates();

    /**
     * Returns a zip file of the templates folder used for single notifications email.
     *
     * @return Zipped file of templates folder.
     */
    ServiceOutcome<File> getEmailTemplatesZip();

    /**
     * Replaces all currently used templates (stored in Shared Jira Home) with default templates. If templates were
     * modified then all changes will be overridden.
     *
     * @return Valid ServiceOutcome when templates replaced
     * Invalid ServiceOutcome with errors otherwise
     */
    ServiceOutcome<Void> revertEmailTemplatesToDefault();
}
