package com.atlassian.jira.jql.util;

import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;

import java.util.stream.Collectors;

/**
 * A base clause visitor that recursively visits each clause in a clause tree, apply mapping and return transformed clause.
 *
 * @since v8.15
 */
public class RecursiveClauseMappingVisitor implements ClauseVisitor<Clause> {

    @Override
    public Clause visit(final AndClause andClause) {
        return new AndClause(
                andClause.getClauses()
                        .stream()
                        .map(clause -> clause.accept(this))
                        .collect(Collectors.toList()));
    }

    @Override
    public Clause visit(final NotClause notClause) {
        return new NotClause(notClause.getSubClause().accept(this));
    }

    @Override
    public Clause visit(final OrClause orClause) {
        return new OrClause(
                orClause.getClauses()
                        .stream()
                        .map(clause -> clause.accept(this))
                        .collect(Collectors.toList()));
    }

    @Override
    public Clause visit(final TerminalClause clause) {
        return clause;
    }

    @Override
    public Clause visit(final WasClause clause) {
        return clause;
    }

    @Override
    public Clause visit(final ChangedClause clause) {
        return clause;
    }
}
