package com.atlassian.jira.jql.query;

import com.atlassian.jira.util.Function;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

/**
 * RangeQueryFactory for TermRangeQueries
 */
public class RangeQueryFactory<T> extends AbstractRangeQueryFactory<T,BytesRef> {
    public static RangeQueryFactory<String> stringRangeQueryFactory() {
        return new RangeQueryFactory<>(BytesRef::new);
    }

    public RangeQueryFactory(final Function<T, BytesRef> valueFactory) {
        super(valueFactory);
    }

    @Override
    Query handleLessThan(final String fieldName, final T value) {
        return new TermRangeQuery(fieldName, null, valueFactory.apply(value), true, false);
    }

    @Override
    Query handleLessThanEquals(final String fieldName, final T value) {
        return new TermRangeQuery(fieldName, null, valueFactory.apply(value), true, true);
    }

    @Override
    Query handleGreaterThan(final String fieldName, final T value) {
        return new TermRangeQuery(fieldName, valueFactory.apply(value), null, false, true);
    }

    @Override
    Query handleGreaterThanEquals(final String fieldName, final T value) {
        return new TermRangeQuery(fieldName, valueFactory.apply(value), null, true, true);
    }

    @Override
    Query handleDuring(final String fieldName, final T lowerValue, final T upperValue) {
        return new TermRangeQuery(fieldName, valueFactory.apply(lowerValue), valueFactory.apply(upperValue), true, true);
    }
}
