package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.ModifiedValue;

import java.util.Map;

public interface IssueUpdater {
    /**
     * Stores any changes to the issue optionally including a changelog or updating an updateDate.
     * Conditionally dispatches an IssueUpdate event if the changes were real and made to significant fields.
     *
     * @param issueUpdateBean      the description of the change.
     * @param generateChangeItems  if true, a changelog group is created.
     * @param updateDate           if true, an updateDate is updated.
     */
    void doUpdate(IssueUpdateBean issueUpdateBean, boolean generateChangeItems, boolean updateDate);

    /**
     * Stores any changes to the issue optionally including a changelog or updating an updateDate.
     * Conditionally dispatches an IssueUpdate event if the changes were real and made to significant fields.
     *
     * @param issueUpdateBean     the description of the change.
     * @param generateChangeItems if true, a changelog group is created.
     * @param updateDate          if true, an updateDate is updated.
     * @param modifiedValueMap    map of field ids and {@link ModifiedValue}s in this update
     */
    default void doUpdate(IssueUpdateBean issueUpdateBean, boolean generateChangeItems, boolean updateDate, Map<String, ModifiedValue> modifiedValueMap) {
        doUpdate(issueUpdateBean, generateChangeItems, updateDate);
    }

    /**
     * Stores any changes to the issue optionally including a changelog and conditionally dispatches an IssueUpdate
     * event if the changes were real and made to significant fields.
     *
     * @param issueUpdateBean      the description of the change.
     * @param generateChangeItems  if true, a changelog group is created.
     */
    void doUpdate(IssueUpdateBean issueUpdateBean, boolean generateChangeItems);

    /**
     * Stores any changes to the issue optionally including a changelog and conditionally dispatches an IssueUpdate
     * event if the changes were real and made to significant fields.
     *
     * @param issueUpdateBean     the description of the change.
     * @param generateChangeItems if true, a changelog group is created.
     * @param modifiedValueMap    map of field ids and {@link ModifiedValue}s in this update
     */
    default void doUpdate(IssueUpdateBean issueUpdateBean, boolean generateChangeItems, Map<String, ModifiedValue> modifiedValueMap) {
        doUpdate(issueUpdateBean, generateChangeItems);
    }
}
