package com.atlassian.jira.issue.tabpanels;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.TabPanelOrder;

import javax.annotation.ParametersAreNonnullByDefault;
import java.util.Date;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public interface ActionExpanderFactory {
    IssueAction getNewerActionsExpander(
            IssueTabPanelModuleDescriptor panelModuleDescriptor,
            String issueKey,
            Date fromDate,
            TabPanelOrder order);

    IssueAction getOlderActionsExpander(
            IssueTabPanelModuleDescriptor panelModuleDescriptor,
            String issueKey,
            Date fromDate,
            TabPanelOrder order);
}
