package com.atlassian.jira.issue.fields.screen;

import com.atlassian.annotations.PublicApi;

import java.util.Collection;

/**
 * Copyright (c) 2002-2004
 * All rights reserved.
 */
@PublicApi
public interface FieldScreenSchemeManager {
    String FIELD_SCREEN_SCHEME_ENTITY_NAME = "FieldScreenScheme";
    Long DEFAULT_FIELD_SCREEN_SCHEME_ID = 1L;

    Collection<FieldScreenScheme> getFieldScreenSchemes();

    FieldScreenScheme getFieldScreenScheme(Long id);

    Collection<FieldScreenSchemeItem> getFieldScreenSchemeItems(FieldScreenScheme fieldScreenScheme);

    /**
     * Does the name already exist for an existing screen scheme
     *
     * @param name The name to check
     * @return True if the name is already used, false otherwise
     * @since v7.4.0
     */
    boolean screenSchemeNameExists(String name);

    void createFieldScreenScheme(FieldScreenScheme fieldScreenScheme);

    void updateFieldScreenScheme(FieldScreenScheme fieldScreenScheme);

    void removeFieldSchemeItems(FieldScreenScheme fieldScreenScheme);

    void removeFieldScreenScheme(FieldScreenScheme fieldScreenScheme);

    void createFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem);

    void updateFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem);

    void removeFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem);

    Collection<FieldScreenScheme> getFieldScreenSchemes(FieldScreen fieldScreen);

    void refresh();
}
