package com.atlassian.jira.issue.fields.screen;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;

import java.util.Collection;
import java.util.List;

/**
 * Copyright (c) 2002-2004
 * All rights reserved.
 */
@PublicApi
public interface FieldScreenManager {
    // Field Screens
    FieldScreen getFieldScreen(Long id);

    Collection<FieldScreen> getFieldScreens();

    /**
     *
     * @param searchQuery - search phrase which screen's name or description may contain
     *
     * @return collection of screens matching the given search phrase
     * @since v8.19
     */
    @ExperimentalApi
    Collection<FieldScreen> getFieldScreens(String searchQuery);

    /**
     *
     * @param startIndex - index where every screen that has its index lower than startIndex will be discarded
     * @param count - upper limit of screens to return
     *
     * @return collection of screens which index is higher than startIndex, limited to specific amount
     * @since v8.19
     */
    @ExperimentalApi
    Collection<FieldScreen> getFieldScreens(int startIndex, int count);

    /**
     *
     * @param startIndex - index where every screen that matches the search query has its index lower than startIndex will be discarded
     * @param count - upper limit of screens with matching search query to return
     * @param searchQuery - search phrase which screen's name or description may contain
     *
     * @return collection of screens matching the given search phrase and which index is higher than startIndex, limited to specific amount
     * @since v8.19
     */
    @ExperimentalApi
    Collection<FieldScreen> getFieldScreens(int startIndex, int count, String searchQuery);

    Collection<FieldScreenTab> getFieldScreenTabs(String fieldId);

    void createFieldScreen(FieldScreen fieldScreen);

    void updateFieldScreen(FieldScreen fieldScreen);

    void removeFieldScreen(Long id);

    // Field Screen Tabs
    void createFieldScreenTab(FieldScreenTab fieldScreenTab);

    void updateFieldScreenTab(FieldScreenTab fieldScreenTab);

    void removeFieldScreenTabs(FieldScreen fieldScreen);

    void removeFieldScreenTab(Long id);

    List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen);

    // Field Screen Layout Items
    void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem);

    void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem);

    void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem);

    void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab);

    List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab);

    void removeFieldScreenItems(String fieldId);

    void refresh();

    FieldScreenLayoutItem buildNewFieldScreenLayoutItem(String fieldId);

    FieldScreenTab getFieldScreenTab(Long fieldScreenTabId);

    boolean screenNameExists(String name);

    /**
     *
     * @param fieldScreen - field screens on which phrase search will be performed
     * @param phrase - search phrase that field screen's name or description should contain
     *
     * @return boolean indicating whether search phrase is present in field screen or not
     * @since v8.19
     */
    boolean screenNameOrDescriptionContains(FieldScreen fieldScreen, String phrase);
}
