package com.atlassian.jira.issue.fields.rest.json.dto;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.attachment.Attachment;

import java.util.Collection;
import java.util.List;

/**
 * @since v6.5
 */
@PublicApi
public interface AttachmentViewDtoConverter {
    Collection<AttachmentViewJsonDto> convert(List<Attachment> attachments);

    /**
     * Converts List of {@link Attachment} to Collection of {@link AttachmentViewJsonDto}, optionally using deferred thumbnails
     * @param attachments List of {@link Attachment} to convert
     * @param deferred convert using deferred thumbnails
     * @return Collections of {@link AttachmentViewJsonDto}
     * @since 8.20.1
     */
    Collection<AttachmentViewJsonDto> convert(List<Attachment> attachments, boolean deferred);
}
