package com.atlassian.jira.issue.fields.option;

import com.atlassian.annotations.Internal;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.text.StringEscapeUtils;

import java.util.Collections;
import java.util.List;

@Internal
public abstract class AbstractOption implements Option, Comparable {
    public String getImagePath() {
        return null;
    }

    public String getImagePathHtml() {
        return StringEscapeUtils.escapeHtml4(getImagePath());
    }

    public String getCssClass() {
        return null;
    }

    public List getChildOptions() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Option)) {
            return false;
        }
        Option rhs = (Option) o;
        return new EqualsBuilder()
                .append(getId(), rhs.getId())
                .isEquals();
    }

    public int compareTo(Object obj) {
        Option o = (Option) obj;
        return new CompareToBuilder()
                .append(getId(), o.getId())
                .toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(41, 5)
                .append(getId())
                .toHashCode();
    }
}
