package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.statistics.StatisticsMapper;

@PublicSpi
public interface CustomFieldStattable {

    /**
     * Since Jira v8.0 a "stattable" field must have a doc value of type: {@link org.apache.lucene.index.SortedDocValues},
     * {@link org.apache.lucene.index.SortedSetDocValues}, {@link org.apache.lucene.index.BinaryDocValues}, or
     * {@link org.apache.lucene.index.NumericDocValues}.
     * Before Jira v8.0 "stattable" fields were retrieved from a Jira cache build from from Lucene index.
     * Since Jira v8.0 this cache is using Lucene {@link org.apache.lucene.index.DocValues} directly.
     * See {@link org.apache.lucene.index.DocValues} and supported implementations for details.
     */
    StatisticsMapper getStatisticsMapper(CustomField customField);
}
