package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.util.UserSearcherHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import webwork.action.Action;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @since v5.2
 */
@Internal
public class GroupCustomFieldSearchRenderer extends CustomFieldRenderer {
    private final CustomField field;
    private final UserSearcherHelper userSearcherHelper;
    private final GroupManager groupManager;

    public GroupCustomFieldSearchRenderer(ClauseNames clauseNames,
                                          CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor,
                                          CustomField field,
                                          CustomFieldValueProvider customFieldValueProvider,
                                          FieldVisibilityManager fieldVisibilityManager,
                                          GroupManager groupManager) {
        super(clauseNames, customFieldSearcherModuleDescriptor, field, customFieldValueProvider, fieldVisibilityManager);
        this.field = field;
        this.groupManager = groupManager;
        userSearcherHelper = ComponentAccessor.getComponent(UserSearcherHelper.class);
    }

    @Override
    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isKickass", true);
        final CustomFieldParams customFieldParams = (CustomFieldParams) fieldValuesHolder.get(field.getId());
        if (customFieldParams != null) {
            final Collection<String> groupNames = customFieldParams.getValuesForNullKey();
            final List<Group> groups = transformUserInput(groupNames);
            params.put("values", groups);
        }

        return super.getViewHtml(searchContext, fieldValuesHolder, displayParameters, action, params);
    }

    @Override
    public String getEditHtml(final ApplicationUser user, final SearchContext searchContext, final FieldValuesHolder fieldValuesHolder, final Map<?, ?> displayParameters, final Action action) {
        HashMap<String, Object> params = new HashMap<>();
        params.put("isKickass", true);
        final CustomFieldParams customFieldParams = (CustomFieldParams) fieldValuesHolder.get(field.getId());
        if (customFieldParams != null) {
            final Collection<String> groupNames = customFieldParams.getValuesForNullKey();
            final List<Group> groups = transformUserInput(groupNames);
            params.put("values", groups);
        }
        userSearcherHelper.addGroupSuggestionParams(user, params);
        return super.getEditHtml(searchContext, fieldValuesHolder, displayParameters, action, params);
    }

    public List<Group> transformUserInput(Collection<String> values) {
        final List<Group> groups = Lists.newArrayListWithCapacity(values.size());
        for (String groupName : values) {
            final Group group = groupManager.getGroup(groupName);
            if (group != null) {
                groups.add(group);
            }
        }
        Collections.sort(groups);
        return groups;
    }
}
