package com.atlassian.jira.i18n.terminology;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import java.util.Optional;

/**
 * This event is fired when terminology has been changed.
 * <p>
 * That means all occurrences of {@code originalName} will be visible as
 * {@code newName} and {@code newNamePlural} instead of {@code oldName} and {@code oldNamePlural}.
 * <p>
 * In Jira Data Center the event is published only for changes done on current Jira node.
 *
 * @since v8.14
 */
@Immutable
@ParametersAreNonnullByDefault
public final class TerminologyEntryChangedEvent extends AbstractTerminologyEvent {

    public TerminologyEntryChangedEvent(final Optional<TerminologyEntry> previousEntry, final TerminologyEntry currentEntry) {
        super(currentEntry.getOriginalName(),
                currentEntry.getNewName(),
                currentEntry.getNewNamePlural(),
                previousEntry.isPresent() ? previousEntry.get().getNewName() : currentEntry.getOriginalName(),
                previousEntry.isPresent() ? previousEntry.get().getNewNamePlural() : currentEntry.getOriginalNamePlural());
    }
}
