package com.atlassian.jira.i18n.terminology;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Represents name mappings of original name {@see TerminologyEntry#getOriginalName} and
 * its plural version {@see Terminology#getOriginalNamePlural}
 * that will be visible as the new name {@see TerminologyEntry#getNewName} and
 * the plural version of the new name {@see TerminologyEntry#getOriginalNamePlural}.
 *
 * @since v8.15
 */
@ExperimentalApi
public interface TerminologyEntry {
    /**
     * @return the original name that will be mapped
     */
    String getOriginalName();

    /**
     * @return the plural version of the original name that will be mapped
     */
    String getOriginalNamePlural();

    /**
     * @return the new name that will be visible in place of the original name
     */
    String getNewName();

    /**
     * @return plural version of the new name that will be visible in place of the plural version of the original name
     */
    String getNewNamePlural();

    /**
     * @return true if either {@link TerminologyEntry#getNewName} or {@link TerminologyEntry#getNewNamePlural} is different
     * than original {@link TerminologyEntry#getOriginalName} or {@link TerminologyEntry#getOriginalNamePlural}.
     */
    boolean hasNonOriginalNames();
}
