package com.atlassian.jira.exception;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Indicates that number of comments per issue exceeded the limit.
 *
 * @since 9.0.0
 */
@ExperimentalApi
public class CommentsPerIssueLimitExceededException extends IllegalArgumentException {

    public CommentsPerIssueLimitExceededException() {
        super("The number of comments for the issue has already reached the limit");
    }
}
