package com.atlassian.jira.event.user;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.user.ApplicationUser;

import java.util.Map;

/**
 * Published when a user cannot change its password.
 *
 * @since v8.12
 */
@Internal
public class CannotChangePasswordEvent extends UserEvent {
    public CannotChangePasswordEvent(Map<String, Object> params, ApplicationUser user) {
        super(params, user, UserEventType.USER_CANNOTCHANGEPASSWORD);
    }
}
