package com.atlassian.jira.event.operation;

import com.atlassian.annotations.ExperimentalApi;

import java.util.Optional;

/**
 * Marks event that can be part of larger set of operations (spanning operation).
 *
 * @since 7.13
 */
@ExperimentalApi
public interface SpanningOperationEvent {
    /**
     * Gets spanning operation that this event is part of.
     *
     * @return spanning operation that this event is part of.
     */
    Optional<SpanningOperation> getSpanningOperation();
}